<?php
/**
 * <pre>
 * Advanced Tags & Prefixes
 * IP.Board v3.2.2
 * Last Updated: 12 September, 2011
 * </pre>
 *
 * @author 		Ryan Hoerr
 * @copyright	(c) 2011 Ryan Hoerr / Sublime Development
 * @link		http://www.sublimism.com
 * @version		2.0.5 (Revision 20007)
 */

/**
 * Do all the ACP Prefix management actions and views
 */

if ( ! defined( 'IN_ACP' ) ) {
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded 'admin.php'.";
	exit();
}

class admin_advancedtagsprefixes_prefixes_prefixes extends ipsCommand
{
	private $html;
	private $form_code;
	private $form_code_js;
	private $han_editor;

	public function doExecute( ipsRegistry $registry ) 
	{
		//-----------------------------------------
		// Load skin
		//-----------------------------------------
		
		$this->html			= $this->registry->output->loadTemplate('cp_skin_prefixes');
		
		//-----------------------------------------
		// Set up stuff
		//-----------------------------------------
		
		$this->form_code	= $this->html->form_code	= 'module=prefixes&amp;section=prefixes';
		$this->form_code_js	= $this->html->form_code_js	= 'module=prefixes&section=prefixes';
		
		//-----------------------------------------
		// Load lang
		//-----------------------------------------
		
		$this->registry->class_localization->loadLanguageFile( array( 'admin_global' ), 'advancedtagsprefixes' );

		///-----------------------------------------
		// What to do...
		//------------------------------------------
		
		$this->prefixes = $this->cache->getCache('topic_prefixes');
		
		switch( $this->request['do'] )
		{
			default:
			case 'display':
				$this->_showAll();
			break;
			
			case 'addnew':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'prefix_addnew' );
				$this->_add();
			break;
			
			case 'edit':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'prefix_edit' );
				$this->_edit();
			break;
			
			case 'delete':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'prefix_delete' );
				$this->_delete();
			break;
			
			case 'doAdd':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'prefix_addnew' );
				$this->_doAdd();
			break;
			
			case 'doEdit':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'prefix_edit' );
				$this->_doEdit();
			break;
			
			case 'searchAndReplace':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'prefix_addnew' );
				$this->_searchAndReplace();
		}
		
		//-----------------------------------------
		// Pass to CP output hander
		//-----------------------------------------
		
		$this->registry->output->html_main .= $this->registry->output->global_template->global_frame_wrapper();
		$this->registry->output->sendOutput();
		
	}
	
	/**
	 * Show the index [all prefixes we've created]
	 */
	protected function _showAll()
	{
		/**
		 * I'm told this query won't play nice in anything but MySQL,
		 * so we'll try to make the drivers happy.
		 */
		if($this->settings['sql_driver'] == 'mysql') {
			$this->DB->build( array(	'select'	=> 'p.*',
										'from'		=> array('topic_prefixes' => 'p'),
										'group'		=> 'prefix_id',
										'order'		=> 'prefix_title asc',
										'add_join'	=> array( array(
												'select'	=> 'count(f.id) as forums',
												'from'		=> array('forums' => 'f'),
												'type'		=> 'left',
												'where'		=> 'f.tag_predefined like concat("%",p.prefix_title,"%")',
											) )
										) );
		}
		else {
			$this->DB->build( array(	'select'	=> 'p.*, "-" as forums',
										'from'		=> array('topic_prefixes' => 'p'),
										'group'		=> 'prefix_id',
										'order'		=> 'prefix_title asc' ) );
		}
		$this->DB->execute();
		
		/**
		 * Do the fetching and displaying
		 */
		$dropdown = array( array( 0, $this->lang->words['pre_select_one'] ) );
		while( $r = $this->DB->fetch() ) {
			$prefixes[ $r['prefix_id'] ]	= $r;
			$dropdown[] = array( $r['prefix_id'], $r['prefix_title'] );
		}
		
		/**
		 * Refresh the prefixes cache
		 */
		$this->cache->setCache( 'topic_prefixes', $prefixes,  array( 'array' => 1 ) );

		/**
		 * Check for legacy files
		 */
		$files = array( IPSLib::getAppDir( 'forums' ) . '/extensions/admin/forum_form.php',
						IPSLib::getAppDir( 'forums' ) . '/modules_admin/prefixes/' );
		foreach( $files as $file ) {
			if( file_exists( $file ) ) {
				$warnings[] = sprintf( $this->lang->words['pre_legacy_file'], $file );
			}
		}
		if( count($warnings) ) {
			$warnings[] = $this->lang->words['pre_legacy_warn_post'];
		}

		/**
		 * Check for the hook
		 */
		$hook = $this->DB->buildAndFetch( array(	'select'	=> '*',
													'from'		=> 'core_hooks',
													'where'		=> 'hook_key="sld_topic_prefixes"' ) );
		if( !count($hook) ) {
			$warnings[] = "Advanced Tags &amp; Prefixes hook is <b>not installed</b>! This application will not function properly without it. Please seek support.";
		}
		elseif( !$hook['hook_enabled'] ) {
			$warnings[] = "Advanced Tags &amp; Prefixes hook is <b>disabled</b>. It must be enabled for this application to function properly. Go to the <a href='".$this->settings['_base_url']."app=core&amp;module=applications&amp;section=hooks&amp;do=hooks_overview'>Hook Manager</a> to enable it.";
		}

		/**
		 * Check settings
		 */
		$tagGroup = $this->DB->buildAndFetch( array(	'select'	=> 'conf_title_id',
														'from'		=> 'core_sys_settings_titles',
														'where'		=> 'conf_title_keyword="globaltags"' ) );
		if( $this->settings['tags_enabled'] == 0 ) {
			$warnings[] = "Possible configuration conflict: <b>Tags are disabled.</b> Tags and prefixes can not be used in this state. To change this, go to the <a href='".$this->settings['_base_url']."app=core&module=settings&section=settings&do=setting_view&conf_group=".$tagGroup['conf_title_id']."'>Tag Settings Group</a> and enable tags.";
		}

		if( $this->settings['tags_can_prefix'] == 1 ) {
			$warnings[] = "Possible configuration conflict: <b>Only administrators can set prefixes.</b> To change this, go to the <a href='".$this->settings['_base_url']."app=core&module=settings&section=settings&do=setting_view&conf_group=".$tagGroup['conf_title_id']."'>Tag Settings Group</a> and change 'Can use a tag as content prefix'.";
		}
		else if( $this->settings['tags_can_prefix'] == 0 ) {
			$warnings[] = "Possible configuration conflict: <b>Prefixes are disabled.</b> To change this, go to the <a href='".$this->settings['_base_url']."app=core&module=settings&section=settings&do=setting_view&conf_group=".$tagGroup['conf_title_id']."'>Tag Settings Group</a> and change 'Can use a tag as content prefix'.";
		}
		
		/**
		 * Make sure we have all the needed columns.
		 */
		if( !$this->DB->checkForField( 'show_prefix_in_desc', 'forums' ) ) {
			$this->DB->addField( 'forums', 'show_prefix_in_desc', 'tinyint(1)', '0' );
		}
		
		$this->registry->output->html .= $this->html->prefixMainScreen( $prefixes, $dropdown, $warnings );
	}
	
	/**
	 * Add-a-prefix form
	 */
	protected function _add()
	{
		$this->registry->output->html .= $this->html->prefixEditForm( );
	}
	
	/**
	 * Change-a-prefix form
	 */
	protected function _edit()
	{
		$prefix_id = intval( $this->request['p'] );
		
		if( $prefix_id < 1 )
			$this->registry->output->showError( $this->lang->words['pre_invalid_id'], 17002 );
		
		/**
		 * Get the current data
		 */
		$data = $this->DB->buildAndFetch( array(	'select'	=> '*',
													'from'		=> 'topic_prefixes',
													'where'		=> 'prefix_id=' . $prefix_id ) );
		
		/**
		 * Find the forums it's enabled in
		 */
		$this->DB->build( array(	'select'	=> 'id',
									'from'		=> 'forums',
									'where'		=> 'tag_predefined like "%' . IPSText::safeslashes( $data['prefix_title'] ) . '%"' ) );
		$this->DB->execute();
		while( $r = $this->DB->fetch() ) {
			$data['forums'][] = $r['id'];
		}
		
		/**
		 * Goooo
		 */
		$this->registry->output->html .= $this->html->prefixEditForm( $data );
	}
	
	/**
	 * Whack-a-prefix
	 */
	protected function _delete()
	{
		$prefix_id = intval($this->request['p']);
		
		if( $prefix_id < 1)
			$this->registry->output->showError( $this->lang->words['pre_invalid_id'], 17002 );
		
		/**
		 * Remove all fingerprints; we don't want to be found...
		 */
		$this->_removeFromForums( $this->prefixes[ $prefix_id ]['prefix_title'] );
		
		$this->DB->delete( 'topic_prefixes', "prefix_id=$prefix_id" );
		
		/**
		 * Goooo
		 */
		$this->registry->adminFunctions->saveAdminLog( sprintf( $this->lang->words['pre_log_deleted'], $this->prefixes[ $prefix_id ]['prefix_title'] ) );
		$this->registry->output->redirect( $this->settings['base_url'] . $this->form_code, $this->lang->words['pre_did_delete'] );
	}
	
	/**
	 * Add a prefix [submit]
	 */
	protected function _doAdd()
	{
		/**
		 * Take care of data validation
		 * Inputs: title, pre, post, showtitle, groups[], forums[]
		 */
		$db_insert = array();
		$db_insert['prefix_title']		= trim( $this->_cleanPrefix( IPSText::safeslashes( $this->request['title'] ) ) );
		$db_insert['prefix_pre']		= trim( IPSText::safeslashes( $_POST['pre'] ) );
		$db_insert['prefix_post']		= trim( IPSText::safeslashes( $_POST['post'] ) );
		$db_insert['prefix_showtitle']	= !((bool) $this->request['showtitle']);
		
		if( count( $this->request['groups'] ) ) {
			foreach( $this->request['groups'] as $group ) {
				if( intval($group) > 0 )
					$db_insert['prefix_groups'][] = intval($group);
			}
			$db_insert['prefix_groups']	= implode(',', $db_insert['prefix_groups']);
		}
		
		if( $db_insert['prefix_title'] == '' )
			$this->registry->output->showError( $this->lang->words['pre_need_title'] , 17001 );

		if( IPSText::mbstrlen($db_insert['prefix_title']) > 255 || IPSText::mbstrlen($db_insert['prefix_pre']) > 255 || IPSText::mbstrlen($db_insert['prefix_post']) > 255)
			$this->registry->output->showError( $this->lang->words['pre_long_field'] , 17003 );
		
		/**
		 * Insert the new prefix
		 */
		$this->DB->insert( 'topic_prefixes', $db_insert );
		$prefix_id = $this->DB->getInsertId();
		
		/**
		 * Add the prefix to the selected forums
		 */
		$this->_addToForums( $this->request['title'], $this->request['forums'] );
		
		/**
		 * Goooo
		 */
		$this->registry->adminFunctions->saveAdminLog( sprintf( $this->lang->words['pre_log_added'], $db_insert['prefix_title'] ) );
		$this->registry->output->redirect( $this->settings['base_url'] . $this->form_code, $this->lang->words['pre_did_add'] );
	}
	
	/**
	 * Edit a prefix [submit]
	 */
	protected function _doEdit()
	{
		/**
		 * Take care of data validation
		 * Inputs: title, pre, post, showtitle, groups[], forums[]
		 */
		$db_insert = array();
		$db_insert['prefix_title']		= trim( $this->_cleanPrefix( IPSText::safeslashes( $this->request['title'] ) ) );
		$db_insert['prefix_pre']		= trim( IPSText::safeslashes( $_POST['pre'] ) );
		$db_insert['prefix_post']		= trim( IPSText::safeslashes( $_POST['post'] ) );
		$db_insert['prefix_showtitle']	= !((bool) $this->request['showtitle']);
		
		$prefix_id = intval($this->request['prefix_id']);
		
		foreach( $this->request['groups'] as $group ) {
			if( intval($group) > 0 )
				$db_insert['prefix_groups'][] = intval($group);
		}
		$db_insert['prefix_groups']	= implode(',', $db_insert['prefix_groups']);
		
		if( $prefix_id < 1)
			$this->registry->output->showError( $this->lang->words['pre_invalid_id'], 17002 );
		
		if( $db_insert['prefix_title'] == '')
			$this->registry->output->showError( $this->lang->words['pre_need_title'], 17001 );

		if( IPSText::mbstrlen($db_insert['prefix_title']) > 255 || IPSText::mbstrlen($db_insert['prefix_pre']) > 255 || IPSText::mbstrlen($db_insert['prefix_post']) > 255)
			$this->registry->output->showError( $this->lang->words['pre_long_field'], 17003 );
		
		/**
		 * Update the prefix
		 */
		$this->DB->update( 'topic_prefixes', $db_insert, 'prefix_id=' . $prefix_id );
		
		/**
		 * Clean up the forum records. This is a little ungraceful, but it works...
		 * 
		 * We need to remove it from every forum before we update them--
		 * otherwise, you'd never be able to remove it from a forum at all.
		 */
		$this->_removeFromForums( $this->prefixes[ $prefix_id ]['prefix_title'] );
		$this->_addToForums( $this->request['title'], $this->request['forums'] );
		
		/**
		 * Goooo
		 */
		$this->registry->adminFunctions->saveAdminLog( sprintf( $this->lang->words['pre_log_edited'], $this->prefixes[ $prefix_id ]['prefix_title'] ) );
		$this->registry->output->redirect( $this->settings['base_url'] . $this->form_code, $this->lang->words['pre_did_edit'] );
	}
	
	/**
	 * Strip the given text from topic titles and insert it as a prefix.
	 */
	protected function _searchAndReplace()
	{
		$find		= IPSText::safeslashes( $this->request['find'] );
		$find_seo	= IPSText::makeSeoTitle( $find );
		$replace	= intval( $this->request['replace'] );
		
		/**
		 * Query won't work for other engines...
		 */
		if( $this->settings['sql_driver'] != 'mysql' || $replace < 1 )
			$this->registry->output->redirect( $this->settings['base_url'] . $this->form_code, "" );
		
		/**
		 * Generate new prefixes.
		 */
		
		/* Load tagging stuff */
		if ( ! $this->registry->isClassLoaded('tags') )
		{
			require_once( IPS_ROOT_PATH . 'sources/classes/tags/bootstrap.php' );/*noLibHook*/
			$this->registry->setClass( 'tags', classes_tags_bootstrap::run( 'forums', 'topics' )  );
		}
		$_REQUEST['ipsTags_prefix'] = 1;

		$this->DB->build( array(	'select'	=> '*',
									'from'		=> 'topics',
									'where'		=> 'title like "' . $find . '%"' ) );
		$this->DB->execute();
		while( $r = $this->DB->fetch() ) {
			/**
			 * Get topic tags
			 */
			$tags = $this->registry->getClass('tags')->getTagsByMetaId( $r['tid'] );;

			if( !count($tags) ) {
				$tags = array( 'tags' => array() );
			}

			/**
			 * Prepend and send back.
			 */
			array_unshift( $tags['tags'], $this->prefixes[ $replace ]['prefix_title'] );
			$this->registry->getClass('tags')->replace( $tags['tags'], array(	'meta_id'			=> $r['tid'],
																				'meta_parent_id'	=> $r['forum_id'] ) );
		}
		
		/**
		 * Do a search-and-replace on topic titles to strip $find.
		 */
		$this->DB->build( array(	'update'	=> 'topics',
									'set'		=> 'title=trim( replace( replace(title, "' . strtolower( $find ) . '", "") , "' . $find . '", "") ), title_seo=trim( leading "-" from replace(title_seo, "' . $find_seo . '", "") )',
									'where'		=> 'title like "' . $find . '%"' ) );
		$this->DB->execute();
		
		/**
		 * Goooo
		 */
		$this->registry->adminFunctions->saveAdminLog( sprintf( $this->lang->words['pre_log_snr'], $this->DB->getAffectedRows(), $find, $this->prefixes[ $replace ]['prefix_title'] ) );
		$this->registry->output->redirect( $this->settings['base_url'] . $this->form_code, sprintf( $this->lang->words['pre_did_snr'], $this->DB->getAffectedRows(), $find ) );
	}
	
	/**
	 * Remove the given tag from all forums with lots of wizardry.
	 */
	protected function _removeFromForums( $toRemove ) {
		$toRemove = IPSText::mbstrtolower( $toRemove );
		
		$this->DB->build( array(	'select'	=> 'id, tag_predefined',
									'from'		=> 'forums',
									'where'		=> 'tag_predefined like "%' . $toRemove . '%"' ) );
		$a = $this->DB->execute();
		while( $r = $this->DB->fetch( $a ) ) {
			$tags = array_filter( explode( ',', $r['tag_predefined'] ) );
			foreach( $tags as $k => $tag ) {
				if( IPSText::mbstrtolower( trim( $tag ) ) == $toRemove ) {
					unset( $tags[ $k ] );
				}
			}
			
			$this->DB->update( 'forums', array( 'tag_predefined' => IPSText::safeslashes( implode( ',', $tags ) ) ), 'id=' . $r['id'] );
		}
		
		return;
	}
	
	/**
	 * Add the given tag to the given forums with lots of wizardry.
	 */
	protected function _addToForums( $toAdd, $ids ) {
		if( count( $ids ) ) {
			foreach( $ids as $forum ) {
				if( intval($forum) > 0 )
					$forums[] = intval($forum);
			}
			
			$this->DB->build( array(	'select'	=> 'id, tag_predefined',
										'from'		=> 'forums',
										'where'		=> 'id in(' . implode( ',', $forums ) . ')' ) );
			$a = $this->DB->execute();
			while( $r = $this->DB->fetch( $a ) ) {
				// Check whether it's already there among any existing tags.
				$tags = array_filter( explode( ',', $r['tag_predefined'] ) );
				if( count( $tags ) ) {
					foreach( $tags as $tag ) {
						if( trim( $tag ) == $toAdd ) {
							continue 2;
						}
					}
				}
				
				// Not found, so add to the list and insert the prefix.
				$tags[] = $toAdd;
				$this->DB->build( array(	'update'	=> 'forums',
											'set'		=> 'tag_predefined="' . IPSText::safeslashes( implode( ',', $tags ) ) . '"',
											'where'		=> 'id=' . $r['id'] ) );
				$this->DB->execute();
			}
		}
		
		return;
	}

	/**
	 * Clean prefixes in accordance with classes_tag_abstract->_stripHtml().
	 */
	protected function _cleanPrefix( $prefix ) {
		return str_replace( array( '&#62;', '&#60;', '&amp;', '&quot;', '&#39;', '<', '>', '"', "'" ), '', $prefix );
	}
}
